#ifdef GL_ES
precision mediump float;
#endif

#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

//.rgb are in range (0.0, 1.0);
vec4 RGBA2HSVA(vec4 inRGBA)
{
    float rgbMax = max(max(inRGBA.x, inRGBA.y), inRGBA.z);
    float rgbMin = min(min(inRGBA.x, inRGBA.y), inRGBA.z);
    float diff = rgbMax - rgbMin;
    
    vec4 outHSVA;
    
    outHSVA.w = inRGBA.w;
    outHSVA.z = rgbMax; //.v
	outHSVA.y = diff / rgbMax;
    return outHSVA;
}

vec4 HSVA2RGBA(vec4 inHSVA) //.r = .h, .g = .s, .b = .v
{
    vec4 outRGBA = (vec4)(1.0f);
    
    outRGBA.w = inHSVA.w;
    
    if(inHSVA.y <= 0.00001f)
    {
        outRGBA.rgb = (vec3)(inHSVA.z);
    }
    else
    {
        float h = inHSVA.x / 60.0f;
        float branch = floor(h);
        float f = h - branch;
        
        float p = inHSVA.z * (1.0f - inHSVA.y);
        float q = inHSVA.z * (1.0f - f * inHSVA.y);
        float t = inHSVA.z * (1.0f - (1.0f - f) * inHSVA.y);
        
        if(branch == 0.0f)
        {
            outRGBA.rgb = (vec3)(inHSVA.z, t, p); 
        }
        else if(branch == 1.0f)
        {
            outRGBA.rgb = (vec3)(q, inHSVA.z, p);
        }
        else if(branch == 2.0f)
        {
            outRGBA.rgb = (vec3)(p, inHSVA.z, t);
        }
        else if(branch == 3.0f)
        {
            outRGBA.rgb = (vec3)(p, q, inHSVA.z);
        }
        else if(branch == 4.0f)
        {
            outRGBA.rgb = (vec3)(t, p, inHSVA.z);
        }
        else //(branch == 5.0)
        {
            outRGBA.rgb = (vec3)(inHSVA.z, p, q);
        }
    }

    return outRGBA;
}

vec4 INPUT(image2d_t src_data,  __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

vec4 INPUT2(image2d_t ovelay1, vec2 tc)
{
	return read_imagef(ovelay1, sampler, tc);
}



__kernel void MAIN(
      __read_only image2d_t src_data,
      __write_only image2d_t dest_data,        //Data in global memory
     __global FilterParam* param,
	  int alpha)  //[0-100]		// the gpu items/threads should be newW*newH
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	float2 resolution = (float2)(W,H);
	
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	vec2 u_zoomRatio = (vec2)(1.0f,1.0f);
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	vec2 tc = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/resolution.xy;
	
    vec2 uv = tc;
    vec4 inBGRA = INPUT(src_data,param, uv);
    vec4 inHSVA = RGBA2HSVA(inBGRA);
    
    vec2 zoomRatio = 1.0f / u_zoomRatio;
    float startLocTexY = (1.0f - zoomRatio.y) / 2.0f;
	uv = (float2)(uv.x, 1.0f - uv.y);
    float uniformTexCoord = (uv.y - startLocTexY) / zoomRatio.y;
    
    inHSVA.x = uniformTexCoord * 360.0f;
    //inHSVA.g = 0.4;
    
    vec4 outBGRA;
	outBGRA.rgb = HSVA2RGBA(inHSVA).rgb;
	
	float4 outputCol = inBGRA*(1.0f - alpha/100.0f)+outBGRA*alpha/100.0f;
	
	write_imagef(dest_data, coordinate, (float4)(outputCol.xyz, inBGRA.w));
}
